<?php
include_once("database.php");

$result = mysqli_query($mysqli, "SELECT * FROM mywedding ORDER BY id DESC");
?>

<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Dika & Bunga Wedding</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-9ndCyUaIbzAi2FUVXJi0CjmCapSmO7SnpJef0486qhLnuZ2cdeRhO02iuK6FUUVM" crossorigin="anonymous">
    
    <link rel="preconnect" href="https://fonts.googleabdpis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Sacramento&family=Work+Sans:wght@100;300;400;600;700&display=swap"
        rel="stylesheet">
    
    <link
        href="https://fonts.googleapis.com/css2?family=Ubuntu:ital,wght@0,300;0,400;0,500;0,700;1,300;1,400;1,500;1,700&display=swap"
        rel="stylesheet">
    
    <!-- simply countdown -->
    <link rel="stylesheet" href="countdown/simplyCountdown.theme.default.css" />
    <script src="countdown/simplyCountdown.min.js"></script>
    
    <!-- bootstrap icon -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    
    <link rel="stylesheet" href="style.css">
    
    <link rel="stylesheet" href="/plugins/animate.css@4.1.1/animate.min.css">
</head>

<body>
    <div class="frame">
        <!-- <img src="/assets/img/frame-tmd.png" alt="frame" class="frame-tm animate__animated animate__fadeInDown animate__slower" style="height: 12%;"> -->
        <img src="/assets/img/frame-tl.png" alt="frame"
            class="frame-tl animate__animated animate__fadeInDown animate__slower frame-img-md">
        <img src="/assets/img/frame-tr.png" alt="frame"
            class="frame-tr animate__animated animate__fadeInDown animate__slower frame-img-md">
        <!-- <img src="/assets/img/frame-md.png" alt="frame"
            class="frame-md animate__animated animate__fadeInUp animate__slower frame-img-sm"> -->
        <img src="/assets/img/frame-bl.png" alt="frame"
            class="frame-bl animate__animated animate__fadeInUp animate__slower frame-img-lg">
        <img src="/assets/img/frame-br.png" alt="frame"
            class="frame-br animate__animated animate__fadeInUp animate__slower frame-img-lg">
    </div>

    <!-- hero -->
    <section id="hero" class="hero text-center justify-content-center align-items-center text-white">
        <main>
            <div class="container shadow-lg">
                <div class="row justify-content-center">
                    <div class="col justify-content-center d-flex align-items-center" style="padding: auto;">
                        <div class="img-frame animate__animated animate__fadeInDown animate__slower">
                            <img src="/assets/img/hero.png">
                        </div>
                    </div>
                </div>

                <div class="animate__animated animate__fadeInDown animate__slower">
                    <!-- <p>UNDANGAN PERNIKAHAN</p><br> -->
                    <h1>Dika & Bunga</h1>
                </div>
                <div class="invitation animate__animated animate__fadeInUp animate__slower">
                    <h4>Kepada YTH;<br> <span></span></h4>
                </div>

                <div class="open-btn">
                    <span>
                        <a href="#home" onClick="enableScroll()">BUKA UNDANGAN</a>
                    </span>
                </div>
            </div>
        </main>
    </section>

    <!-- navbar -->
    <nav class="navbar navbar-expand-md bg-transparent sticky-top mynavbar">
        <div class="container">
            <a class="navbar-brand" href="#">DB</a>
            <button class="navbar-toggler border-0" type="button" data-bs-toggle="offcanvas"
                data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasNavbar"
                aria-labelledby="offcanvasNavbarLabel">
                <div class="offcanvas-header">
                    <!-- <h5 class="offcanvas-title" id="offcanvasNavbarLabel"></h5> -->
                    <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                </div>
                <div class="offcanvas-body">
                    <div class="navbar-nav ms-auto">
                        <button type="button" data-bs-dismiss="offcanvas">
                            <a class="nav-link" href="#home">
                                <div class="row justify-content-center">
                                    <div class="col text-center">
                                        <i class="bi bi-house-heart"></i>
                                        <p style="font-size: 0.75rem;">Home</p>
                                    </div>
                                </div>
                            </a>
                        </button>
                        <button type="button" data-bs-dismiss="offcanvas">
                            <a class="nav-link" href="#quotes">
                                <div class="row justify-content-center">
                                    <div class="col text-center">
                                        <i class="bi bi-card-text"></i>
                                        <p style="font-size: 0.75rem;">Quotes</p>
                                    </div>
                                </div>
                            </a>
                        </button>
                        <button type="button" data-bs-dismiss="offcanvas">
                            <a class="nav-link" href="#information">
                                <div class="row justify-content-center">
                                    <div class="col text-center">
                                        <i class="bi bi-clock"></i>
                                        <p style="font-size: 0.75rem;">Acara</p>
                                    </div>
                                </div>
                            </a>
                        </button>
                        <button type="button" data-bs-dismiss="offcanvas">
                            <a class="nav-link" href="#story">
                                <div class="row justify-content-center">
                                    <div class="col text-center">
                                        <i class="bi bi-person-hearts"></i>
                                        <p style="font-size: 0.75rem;">Cerita</p>
                                    </div>
                                </div>
                            </a>
                        </button>
                        <button type="button" data-bs-dismiss="offcanvas">
                            <a class="nav-link" href="#gallery">
                                <div class="row justify-content-center">
                                    <div class="col text-center">
                                        <i class="bi bi-image"></i>
                                        <p style="font-size: 0.75rem;">Galeri</p>
                                    </div>
                                </div>
                            </a>
                        </button>
                        <button type="button" data-bs-dismiss="offcanvas">
                            <a class="nav-link" href="#comment">
                                <div class="row justify-content-center">
                                    <div class="col text-center">
                                        <i class="bi bi-envelope-paper-heart-fill"></i>
                                        <p style="font-size: 0.75rem;">Ucapan</p>
                                    </div>
                                </div>
                            </a>
                        </button>
                        <button type="button" data-bs-dismiss="offcanvas">
                            <a class="nav-link" href="#gifts">
                                <div class="row justify-content-center">
                                    <div class="col text-center">
                                        <i class="bi bi-gift"></i>
                                        <p style="font-size: 0.75rem;">Hadiah</p>
                                    </div>
                                </div>
                            </a></button>
                    </div>
                </div>
            </div>
        </div>
    </nav>

    <!-- main content -->
    <!-- home -->
    <section id="home" class="home">
        <div class="container shadow-lg">
            <div class="row justify-content-center">
                <div class="block col-md-8 text-center">
                    <h2>Undangan Pernikahan</h2>
                </div>
                <div class="block col-md-8 text-center">
                    <h3>اَلسَّلَامُ عَلَيْكُمْ وَرَحْمَةُ اللهِ وَبَرَكَا تُهُ</h3>
                </div>
                <div class="block col-md-8 text-center">
                    <p>Maha suci Allah yang telah menciptakan makhluk-Nya berpasang-pasangan.
                        <br>Ya Allah dengan kerendahan hati, perkenankanlah kami menikahkan putra-putri kami :
                    </p>
                </div>
            </div>

            <div class="row couple">
                <div class="col-lg-6">
                    <div class="block row">
                        <div class="col-8 text-end">
                            <h3>Dika Nur Sudrajad</h3>
                            <p>Putra pertama <br> Bapak Winardi <br> Ibu Siti Maryatun</p>
                        </div>

                        <div class="col-4">
                            <img src="/assets/img/dika.png" alt="Dika Nur Sudrajad" class="img-responsive">
                            </div>
                    </div>
                </div>

                <div class="line-2 col-lg-6">
                    <div class="block row">
                        <div class="col-4">
                            <img src="/assets/img/bunga.png" alt="Arfian Bunga Aprilia" class="img-responsive">
                        </div>

                        <div class="col-8">
                            <h3>Arfian Bunga Aprilia</h3>
                            <p>Putri pertama <br> Bapak Sardi Rinaldi <br> Ibu Dewi Setyawati</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <img src="/assets/img/frame-bl.png" alt="content-frame" class="block-bl content-frame-bl content-frame-img">
        <img src="/assets/img/frame-br.png" alt="content-frame" class="block-br content-frame-br content-frame-img">
    </section>

    <!-- quotes -->
    <section id="quotes" class="quotes">
        <div class="container shadow-lg">
            <div class="row justify-content-center">
                <div class="col-md-8 text-center">
                    <img class="block" src="/assets/img/surat.png" alt="" style="width: 40%;">
                    <p class="block ayat">بِسْمِ اللّٰهِ الرَّحْمٰنِ الرَّحِيْمِ</p>
                    <p class="block ayat">
                        وَمِنْ اٰيٰتِهٖٓ اَنْ خَلَقَ لَكُمْ مِّنْ اَنْفُسِكُمْ اَزْوَاجًا لِّتَسْكُنُوْٓا اِلَيْهَا
                        وَجَعَلَ بَيْنَكُمْ مَّوَدَّةً وَّرَحْمَةً ۗاِنَّ فِيْ ذٰلِكَ لَاٰيٰتٍ لِّقَوْمٍ
                        يَّتَفَكَّرُوْنَ
                    </p>
                    <p class="block translate">
                        (Wa min āyātihī an khalaqa lakum min anfusikum azwājal litaskunū ilaihā wa ja‘ala bainakum
                        mawaddataw wa raḥmah(tan), inna fī żālika la'āyātil liqaumiy yatafakkarūn)
                        <br><br>
                        Dan di antara tanda-tanda (kebesaran)-Nya ialah Dia menciptakan pasangan-pasangan untukmu dari
                        jenismu sendiri, agar kamu cenderung dan merasa tenteram kepadanya, dan Dia menjadikan
                        diantaramu rasa kasih dan sayang. Sungguh, pada yang demikian itu benar-benar terdapat
                        tanda-tanda (kebesaran Allah) bagi kaum yang berpikir. (Ar-Rum · Ayat 21)
                    </p>
                </div>
            </div>
        </div>

        <img src="/assets/img/frame-bl.png" alt="content-frame" class="block-bl content-frame-bl content-frame-img">
        <img src="/assets/img/frame-br.png" alt="content-frame" class="block-br content-frame-br content-frame-img">
    </section>

    <!-- informasi acara -->
    <section id="information" class="information">
        <div class="container shadow-lg">
            <div class="row justify-content-center">
                <div class="block col-md-8 col-10 text-center">
                    <h3>Informasi Acara</h3>
                </div>
            </div>

            <div class="row justify-content-center mt-4">
                <div class="block col col-6 akad">
                    <div class="card text-center text-bg-light mb-5">
                        <div class="card-header">
                            Ngunduh Mantu
                        </div>
                        <div class="card-body">
                            <div class="row justify-content-center">
                                <div class="col col-7">
                                    <i class="bi bi-calendar3 d-block"></i>
                                    <span>Selasa, 8 April 2025</span>
                                </div>
                                <div class="col col-5">
                                    <i class="bi bi-clock d-block"></i>
                                    <span>12.00 - selesai</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!--<div class="block col col-6 boyong">-->
                <!--    <div class="card text-center text-bg-light">-->
                <!--        <div class="card-header">-->
                <!--            Boyong Manten-->
                <!--        </div>-->
                <!--        <div class="card-body">-->
                <!--            <div class="row justify-content-center">-->
                <!--                <div class="col col-7">-->
                <!--                    <i class="bi bi-calendar3 d-block"></i>-->
                <!--                    <span>Selasa, 8 April 2025</span>-->
                <!--                </div>-->
                <!--                <div class="col col-5">-->
                <!--                    <i class="bi bi-clock d-block"></i>-->
                <!--                    <span>12.00 - selesai</span>-->
                <!--                </div>-->
                <!--            </div>-->
                <!--        </div>-->
                <!--    </div>-->
                <!--</div>-->
            </div>

            <div class="row justify-content-center mt-4">
                <div class="block col-md-8 col-10 text-center">
                    <p class="address">Rumah mempelai pria<br>Alamat : Karanganyar, Mliwis, Cepogo,Boyolali</p>
                    <div class="map-btn">
                        <span class="noselect">
                            <a href="https://maps.app.goo.gl/DtfzPfcY6gUE6yqU9" target="_blank">Klik Untuk Membuka Peta</a>
                        </span>
                    </div>
                </div>
            </div>

            <div class="row justify-content-center">
                <div class="block col-md-8 col-10 text-center">
                    <div class="simply-countdown"></div>
                </div>
            </div>
        </div>

        <img src="/assets/img/frame-bl.png" alt="content-frame" class="block-bl content-frame-bl content-frame-img">
        <img src="/assets/img/frame-br.png" alt="content-frame" class="block-br content-frame-br content-frame-img">
    </section>

    <!-- story -->
    <section id="story" class="story">
        <div class="container shadow-lg">
            <div class="row justify-content-center">
                <div class="block col-md-8 col-10 text-center">
                    <span class="block"> Bagaimana Cinta Kami Bersemi? </span>
                    <h2 class="block">Cerita Kami</h2>
                    <p class="block">
                        Berikut cerita singkat kisah kami.
                    </p>
                </div>
            </div>

            <div class="row justify-content-center mt-4">
                <div class="col col-12">
                    <ul class="timeline">
                        <li class="block timeline">
                            <div class="timeline-image shadow" style="background-image: url(/assets/img/sinus.jpg);"></div>
                            <div class="timeline-panel shadow">
                                <div class="timeline-heading">
                                    <h3>Pertama Bertemu</h3>
                                    <span>1 Agustus 2020</span>
                                </div>

                                <div class="timeline-body">
                                    <p>
                                        Kami pertama kali bertemu ketika sama-sama menempuh pendidikan di STMIK SINAR
                                        NUSANTARA Surakarta.
                                    </p>
                                </div>
                            </div>
                        </li>

                        <li class="block timeline-inverted">
                            <div class="timeline-image shadow" style="background-image: url(/assets/img/malioboro.jpg);"></div>
                            <div class="timeline-panel shadow">
                                <div class="timeline-heading">
                                    <h3>Mulai Serius</h3>
                                    <span>7 Agustus 2022</span>
                                </div>

                                <div class="timeline-body">
                                    <p>
                                        Seiring berjalannya waktu, kami menemukan kecocokan dan kesamaan pemikiran. Kali
                                        pertama kami memutuskan untuk mulai serius yaitu ketika kami melakukan
                                        perjalanan ke Malioboro Jogjakarta.
                                    </p>
                                </div>
                            </div>
                        </li>

                        <li class="block timeline">
                            <div class="timeline-image shadow" style="background-image: url(/assets/img/tunangan.jpg);"></div>
                            <div class="timeline-panel shadow">
                                <div class="timeline-heading">
                                    <h3>Tunangan</h3>
                                    <span>6 Mei 2023</span>
                                </div>

                                <div class="timeline-body">
                                    <p>
                                        Kami melangsungkan prosesi tunangan untuk mempererat hubungan keluarga dan
                                        sebagai tanda bahwa kami benar-benar mulai serius untuk menuju pernikahan.
                                    </p>
                                </div>
                            </div>
                        </li>

                        <li class="block timeline-inverted">
                            <div class="timeline-image shadow" style="background-image: url(/assets/img/pernikahan.png);"></div>
                            <div class="timeline-panel shadow">
                                <div class="timeline-heading">
                                    <h3>Pernikahan</h3>
                                    <span>5 April 2025</span>
                                </div>

                                <div class="timeline-body">
                                    <p>
                                        Setelah proses yang cukup panjang untuk menyelesaikan pendidikan, insya Allah
                                        dengan izin Allah kami akan melangsungkan pernikahan.
                                    </p>
                                </div>
                            </div>
                        </li>
                        
                        <li class="block timeline">
                            <div class="timeline-image shadow" style="background-image: url(/assets/img/ngunduh.png);"></div>
                            <div class="timeline-panel shadow">
                                <div class="timeline-heading">
                                    <h3>Ngunduh mantu</h3>
                                    <span>8 April 2025</span>
                                </div>

                                <div class="timeline-body">
                                    <p>
                                        Dengan izin Allah, insya Allah kami akan melangsungkan prosesi Ngunduh Mantu.
                                    </p>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <img src="/assets/img/frame-bl.png" alt="content-frame" class="block-bl content-frame-bl content-frame-img">
        <img src="/assets/img/frame-br.png" alt="content-frame" class="block-br content-frame-br content-frame-img">
    </section>

    <!-- gallery -->
    <section id="gallery" class="gallery">
        <div class="container shadow-lg">
            <div class="row justify-content-center">
                <div class="col text-center">
                    <span class="block"> Memori Kisah Kami </span>
                    <h2 class="block">Galeri Foto</h2>
                    <p class="block">
                        Momen terbaik yang kami abadikan melalui foto.
                    </p>
                </div>
            </div>

            <div class="row thumb row-cols-lg-4 row-cols-sm-2 row-cols-1 justify-content-center">
                <div class="col mt-3">
                    <a href="/assets/img/gallery/1.png" data-toggle="lightbox" data-caption="Gunung Prau"
                        data-gallery="mygallery">
                        <span>
                            <img src="/assets/img/gallery/thumbnail/1.png" alt="Gunung Prau" class="block img-fluid rounded shadow-lg" style="border: 0.15rem solid #AACB73;">
                        </span>
                    </a>
                </div>
                <div class="col mt-3">
                    <a href="/assets/img/gallery/2.jpg" data-toggle="lightbox" data-caption="Pantai Melasti"
                        data-gallery="mygallery">
                        <img src="/assets/img/gallery/thumbnail/2.jpg" alt="Pantai Melasti" class="block img-fluid rounded shadow-lg" style="border: 0.15rem solid #AACB73;">
                    </a>
                </div>
                <div class="col mt-3">
                    <a href="/assets/img/gallery/3.jpg" data-toggle="lightbox" data-caption="Desa Panglipuran"
                        data-gallery="mygallery">
                        <img src="/assets/img/gallery/thumbnail/3.jpg" alt="Desa Panglipuran" class="block img-fluid rounded shadow-lg" style="border: 0.15rem solid #AACB73;">
                    </a>
                </div>
                <div class="col mt-3">
                    <a href="/assets/img/gallery/4.jpg" data-toggle="lightbox" data-caption="Pantai Kuta"
                        data-gallery="mygallery">
                        <img src="/assets/img/gallery/thumbnail/4.jpg" alt="Pantai Kuta" class="block img-fluid rounded shadow-lg" style="border: 0.15rem solid #AACB73;">
                    </a>
                </div>
                <div class="col mt-3">
                    <a href="/assets/img/gallery/5.jpg" data-toggle="lightbox" data-caption="Tunangan" data-gallery="mygallery">
                        <img src="/assets/img/gallery/thumbnail/5.jpg" alt="Tunangan" class="block img-fluid rounded shadow-lg" style="border: 0.15rem solid #AACB73;">
                    </a>
                </div>
                <div class="col mt-3">
                    <a href="/assets/img/gallery/6.jpg" data-toggle="lightbox" data-caption="Wisuda" data-gallery="mygallery">
                        <img src="/assets/img/gallery/thumbnail/6.jpg" alt="Wisuda" class="block img-fluid rounded shadow-lg" style="border: 0.15rem solid #AACB73;">
                    </a>
                </div>
                <!--<div class="col mt-3">-->
                <!--    <a href="/assets/img/gallery/7.jpg" data-toggle="lightbox" data-caption="Gunung Lawu" data-gallery="mygallery">-->
                <!--        <img src="/assets/img/gallery/thumbnail/7.jpg" alt="Gunung Lawu" class="block img-fluid rounded shadow-lg" style="border: 0.15rem solid #AACB73;">-->
                <!--    </a>-->
                <!--</div>-->
                <div class="col mt-3">
                    <a href="/assets/img/gallery/8.jpg" data-toggle="lightbox" data-caption="Bali" data-gallery="mygallery">
                        <img src="/assets/img/gallery/thumbnail/8.jpg" alt="Bali" class="block img-fluid rounded shadow-lg" style="border: 0.15rem solid #AACB73;">
                    </a>
                </div>
                <div class="col mt-3">
                    <a href="/assets/img/gallery/9.jpg" data-toggle="lightbox" data-caption="Tanah Lot" data-gallery="mygallery">
                        <img src="/assets/img/gallery/thumbnail/9.jpg" alt="Tanah Lot" class="block img-fluid rounded shadow-lg" style="border: 0.15rem solid #AACB73;">
                    </a>
                </div>
            </div>
        </div>

        <!-- <img src="/assets/img/frame-bl.png" alt="content-frame" class="block-bl content-frame-bl content-frame-img">
        <img src="/assets/img/frame-br.png" alt="content-frame" class="block-br content-frame-br content-frame-img"> -->
    </section>

    <!-- comment -->
    <section id="comment" class="comment">
        <div class="container shadow-lg">
            <div class="block row justify-content-center">
                <div class="col-md-8 col-10 text-center">
                    <h2>Kirim Ucapan</h2>
                </div>
            </div>

            <div class="row justify-content-center mt-5 content-margin">
                <div class="col-md-8 col-10 text-center">
                    <form action="add.php" method="POST">
                        <input id="name" type="text" name="url" hidden value="<?php echo $actual_link = "https://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]"; ?>">
                        <input id="names" type="text" name="names" class="block form-control" placeholder="Nama..." required>
                        <br>
                        <textarea id="comments" rows="4" cols="50" name="comments" class="block form-control"
                            placeholder="Ucapan..." required></textarea>
                        <br>
                        <div class="submit-btn">
                            <span>
                                <!-- <input class="submit-btn" type="submit" name="submit" value="Kirim"> -->
                                <input type="submit" name="submit" value="KIRIM" class="block">
                            </span>
                        </div>
                    </form>
                </div>

                <!-- comment submited -->
                <div class="col-md-8 col-10 text-center mt-4">
                    <div class="container-card text-center p-3">
                        <?php
                        while ($user_data = mysqli_fetch_array($result)) {
                        ?>
                            <div class="block comment-card mb-3 p-3">
                                <div class="card-header"><?php echo "" . $user_data['names'] ?></div>
                                <div class="card-body"><?php echo "" . $user_data['comments'] ?></div>
                            </div>
                        <?php
                        }
                        ?>
                    </div>
                </div>
            </div>

            <img src="/assets/img/frame-bl.png" alt="content-frame" class="block-bl content-frame-bl content-frame-img">
            <img src="/assets/img/frame-br.png" alt="content-frame" class="block-br content-frame-br content-frame-img">
    </section>

    <!-- gifts -->
    <section id="gifts" class="gifts">
        <div class="container shadow-lg">
            <div class="row justify-content-center">
                <div class="col col-md-8 col-10 text-center">
                    <h2 class="block">Kirim Hadiah</h2>
                    <p class="block">Terima kasih telah menambah semangat kegembiraan pernikahan kami dengan kehadiran
                        dan hadiah dari
                        anda.
                    </p>
                </div>
            </div>

            <div class="row justify-content-center mt-4">
                <div class="block col col-6 bank-0">
                    <div class="card text-center mb-5">
                        <div class="card-body">
                            <div class="row justify-content-center">
                                <div class="col col-12">
                                    <input type="text" value="8175573867" id="bank_0" style="display: none;">
                                    <button type="submit" onclick="bankFunction_0()">
                                        <h3>BCA</h3>
                                        <span>3931159338</span><br>
                                        <span>Dika Nur Sudrajad</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="block col col-6 bank-1">
                    <div class="card text-center">
                        <div class="card-body">
                            <div class="row justify-content-center">
                                <div class="col col-12">
                                    <input type="text" value="3931159338" id="bank_1" style="display: none;">
                                    <button type="button" onclick="bankFunction_1()">
                                        <h3>BCA</h3>
                                        <span>8175573867</span><br>
                                        <span>Arfian Bunga Aprilia</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row justify-content-center">
                <div class="col col-md-8 col-10 text-center">
                    <p class="block">Klik untuk menyalin nomor rekening </p>
                </div>
            </div>
        </div>
    </section>

    <footer>
        <div class="container">
            <div class="col text-center">
                <small class="block">Made With Love By : Dika Nur Sudrajad &copy;2025.</small>

                <ul class="mt-3">
                    <li> 
                        <a href="https://www.linkedin.com/in/dika-nur-sudrajad-373a65208/" target="_blank"><i class="bi bi-linkedin"></i></a>
                    </li>
                    <li> 
                        <a href="https://instagram.com/genyo_jr" target="_blank"><i class="bi bi-instagram"></i></a>
                    </li>
                    <li> 
                        <a href="https://x.com/gondrongraurus" target="_blank"><i class="bi bi-twitter"></i></a> 
                    </li>
                    <li> 
                        <a href="https://wa.me/6285803411982" target="_blank"><i class="bi bi-whatsapp"></i></a> 
                    </li>
                    <li> 
                        <a href="https://t.me/suko_nedo" target="_blank"><i class="bi bi-telegram"></i></a> 
                    </li>
                </ul>
            </div>
        </div>
    </footer>

    <!-- audio container -->
    <div id="audio-container">
        <audio id="song" preload="auto" autoplay loop>
            <source src="audio/wedding-nasheed.mp3" type="audio/mp3">
        </audio>

        <div class="audio-icon-wrapper" style="display: none;">
            <i class="bi bi-disc"></i>
        </div>
    </div>

    <!-- play -->
    <script>
        const rootElement = document.querySelector(":root");
        const audioIconWrapper = document.querySelector('.audio-icon-wrapper');
        const audioIcon = document.querySelector('.audio-icon-wrapper i');
        const frameWrapper = document.querySelector(".frame-wrapper");
        const song = document.querySelector('#song');        
        let isPlaying = false;

        function disableScroll() {
            scrollTop = window.pageYOffset || document.documentElement.scrollTop;
            scrollLeft = window.pageXOffset || document.documentElement.scrollLeft;

            window.onscroll = function() {
                window.scrollTo(scrollTop, scrollLeft);
            }

            rootElement.style.scrollBehavior = 'auto';
        }

        function enableScroll() {
            window.onscroll = function() {}
            rootElement.style.scrollBehavior = 'smooth';
            //localStorage.setItem('opened', 'true');
            playAudio();
        }

        function playAudio() {
            song.play();
            isPlaying = true;
            song.volume = 0.8;
            audioIconWrapper.style.display = "flex";
            frameWrapper.style.display = "flex";
        }

        audioIconWrapper.onclick = function() {
            if (isPlaying) {
                song.pause();
                audioIcon.classList.remove('bi-disc');
                audioIcon.classList.add('bi-pause-circle');
            } else {
                song.play();
                audioIcon.classList.add('bi-disc');
                audioIcon.classList.remove('bi-pause-circle');
            }

            isPlaying = !isPlaying;
        }

        disableScroll();

        // if (localStorage.getItem('opened')) {
        //     enableScroll();
        // } else {
        //     disableScroll();
        // }
    </script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-geWF76RCwLtnZ8qwWowPQNguL3RmwHVBC9FhGdlKrxdiJJigb/j/68SIy3Te4Bkz"
        crossorigin="anonymous"></script>

    <script src="https://cdn.jsdelivr.net/npm/bs5-lightbox@1.8.3/dist/index.bundle.min.js"></script>

    <!-- bank copy -->
    <script>
        function bankFunction_0() {
            var text_0 = document.getElementById("bank_0");
            text_0.select();
            text_0.setSelectionRange(0, 99999);
            navigator.clipboard.writeText(text_0.value);
            alert("Copied to clipboard");
        }

        function bankFunction_1() {
            var text_1 = document.getElementById("bank_0");
            text_1.select();
            text_1.setSelectionRange(0, 99999);
            navigator.clipboard.writeText(text_1.value);
            alert("Copied to clipboard");
        }
    </script>

    <!-- countdown -->
    <script>
        simplyCountdown('.simply-countdown', {
            year: 2025, // Target year [YYYY]
            month: 4, // Target month [1-12]
            day: 8, // Target day [1-31]
            hours: 12, // Target hours [0-23]
            words: {
                days: {
                    singular: 'hari',
                    plural: 'hari'
                },
                hours: {
                    singular: 'jam',
                    plural: 'jam'
                },
                minutes: {
                    singular: 'menit',
                    plural: 'menit'
                },
                seconds: {
                    singular: 'detik',
                    plural: 'detik'
                }
            },
        });
    </script>

    <!-- navbar -->
    <script>
        const stickyTop = document.querySelector('.sticky-top');
        const offcanvas = document.querySelector('.offcanvas');

        offcanvas.addEventListener('show.bs.offcanvas', function() {
            stickyTop.style.overflow = 'visible';
        });

        offcanvas.addEventListener('hidden.bs.offcanvas', function() {
            stickyTop.style.overflow = 'hidden';
        });
    </script>

    <!-- hero pronouns -->
    <script>
        const urlParams = new URLSearchParams(window.location.search);
        const name = urlParams.get('n') || '';
        const pronoun = urlParams.get('p') || 'Bapak/Ibu/Saudara/i';
        const nameContainer = document.querySelector('.hero h4 span');
        const nameContainerHome = document.querySelector('.home h4 span');
        nameContainer.innerText = `${pronoun} ${name},`.replace(/ ,$/, ',');
        nameContainerHome.innerText = `${pronoun} ${name},`.replace(/ ,$/, ',');

        document.querySelector('#name').value = name;
    </script>

    <!-- comment -->
    <script>
        function commentFunction() {
            if (isset($_POST['Kirim'])) {
                $names = $_POST['names'];
                $comments = $_POST['comments'];

                // include database connection file
                include_once("database.php");

                // Insert user data into table
                $result = mysqli_query($mysqli, "INSERT INTO mywedding(names,comments) VALUES('$names','$comments')");
            }
        }
    </script>
</body>

</html>